/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.helpers;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.api.util.Shape;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class Settings
implements INBTSerializable<CompoundNBT> {
    public static final Settings instance = new Settings();
    private BlockPos pos = null;
    private boolean isMirrored = false;
    @Nullable
    private Blueprint blueprint = null;
    private int rotation = 0;
    private String structureName = null;
    private Optional<BlockPos> anchorPos = Optional.empty();
    private String style = "";
    private int width = 1;
    private int height = 1;
    private int length = 1;
    private int frequency = 1;
    private String equation = "";
    private boolean hollow = false;
    private Shape shape = Shape.CUBE;
    private Tuple<BlockPos, BlockPos> box = null;
    private boolean staticSchematicMode = false;
    private String staticSchematicName = null;
    private Tuple<ItemStack, ItemStack> stack = new Tuple((Object)new ItemStack((IItemProvider)Blocks.field_150340_R), (Object)new ItemStack((IItemProvider)Blocks.field_150340_R));
    private boolean shouldRefresh = false;
    private boolean receivedInfo;
    private boolean isStructurizePass = false;

    private Settings() {
    }

    public void startStructurizePass() {
        this.isStructurizePass = true;
    }

    public void endStructurizePass() {
        this.isStructurizePass = false;
    }

    public boolean isStructurizePass() {
        return this.isStructurizePass;
    }

    public boolean shouldRefresh() {
        if (!this.isStructurizePass()) {
            return false;
        }
        boolean ret = this.shouldRefresh;
        this.shouldRefresh = false;
        return ret;
    }

    public void scheduleRefresh() {
        this.shouldRefresh = true;
    }

    public void setupStaticMode(String name) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public Tuple<BlockPos, BlockPos> getBox() {
        return this.box;
    }

    public void setBox(Tuple<BlockPos, BlockPos> box) {
        this.box = box;
    }

    public void setPosition(BlockPos position) {
        this.pos = position;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void moveTo(BlockPos pos) {
        if (this.blueprint == null) {
            return;
        }
        this.pos = this.pos.func_177971_a((Vector3i)pos);
    }

    @Nullable
    public Blueprint getActiveStructure() {
        return this.blueprint;
    }

    public void setActiveSchematic(Blueprint blueprint) {
        if (blueprint == null) {
            this.resetBlueprint();
        } else {
            this.blueprint = blueprint;
            this.blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.rotation), this.isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, (World)Minecraft.func_71410_x().field_71441_e);
        }
    }

    public void reset() {
        this.resetBlueprint();
        this.rotation = 0;
        this.isMirrored = false;
        this.hollow = false;
        this.structureName = null;
        this.pos = null;
        this.box = null;
        this.equation = "";
    }

    public void softReset() {
        this.resetBlueprint();
        this.hollow = false;
        this.pos = null;
        this.box = null;
        this.equation = "";
    }

    public void resetBlueprint() {
        this.blueprint = null;
        this.staticSchematicMode = false;
        this.staticSchematicName = null;
    }

    public void setSchematicInfo(String structureName, int rotation) {
        this.structureName = structureName;
        this.rotation = rotation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        int offset = rotation - this.rotation;
        this.rotation = rotation;
        if (this.blueprint != null) {
            this.blueprint.rotateWithMirror(offset == 1 || offset == -3 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90, Mirror.NONE, (World)Minecraft.func_71410_x().field_71441_e);
        }
        this.scheduleRefresh();
    }

    public void mirror() {
        if (this.blueprint == null) {
            return;
        }
        this.isMirrored = !this.isMirrored;
        this.blueprint.rotateWithMirror(Rotation.NONE, this.rotation % 2 == 0 ? Mirror.FRONT_BACK : Mirror.LEFT_RIGHT, (World)Minecraft.func_71410_x().field_71441_e);
        this.scheduleRefresh();
    }

    public Mirror getMirror() {
        if (this.isMirrored) {
            return Mirror.FRONT_BACK;
        }
        return Mirror.NONE;
    }

    public boolean isStaticSchematicMode() {
        return this.staticSchematicMode;
    }

    public String getStaticSchematicName() {
        return this.staticSchematicName;
    }

    public void setShape(String s) {
        this.shape = Shape.valueOf(s);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setBlock(ItemStack s, boolean mainBlock) {
        this.stack = mainBlock ? new Tuple((Object)s, this.stack.func_76340_b()) : new Tuple(this.stack.func_76341_a(), (Object)s);
    }

    public ItemStack getBlock(boolean main) {
        return main ? (ItemStack)this.stack.func_76341_a() : (ItemStack)this.stack.func_76340_b();
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.isMirrored = nbt.func_74767_n("mirror");
        this.staticSchematicMode = nbt.func_74767_n("static");
        this.hollow = nbt.func_74767_n("hollow");
        this.rotation = nbt.func_74762_e("rot");
        this.width = nbt.func_74762_e("w");
        this.height = nbt.func_74762_e("h");
        this.length = nbt.func_74762_e("len");
        this.frequency = nbt.func_74762_e("freq");
        this.shape = nbt.func_74764_b("shape") ? Shape.values()[nbt.func_74762_e("shape")] : Shape.CUBE;
        this.pos = nbt.func_74764_b("pos") ? NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos")) : null;
        this.box = nbt.func_74764_b("box") ? new Tuple((Object)NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("box")), (Object)NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("box2"))) : null;
        this.structureName = nbt.func_74764_b("struct_name") ? nbt.func_74779_i("struct_name") : null;
        this.staticSchematicName = nbt.func_74764_b("static_name") ? nbt.func_74779_i("static_name") : null;
        this.stack = nbt.func_74764_b("stack") ? new Tuple((Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack")), (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack2"))) : new Tuple((Object)new ItemStack((IItemProvider)Blocks.field_150340_R), (Object)new ItemStack((IItemProvider)Blocks.field_150340_R));
        if (nbt.func_74764_b("equa")) {
            this.equation = nbt.func_74779_i("equa");
        }
        if (nbt.func_74764_b("anch_pos")) {
            this.anchorPos = Optional.of(NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("anch_pos")));
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("mirror", this.isMirrored);
        nbt.func_74757_a("static", this.staticSchematicMode);
        nbt.func_74757_a("hollow", this.hollow);
        nbt.func_74768_a("rot", this.rotation);
        nbt.func_74768_a("w", this.width);
        nbt.func_74768_a("h", this.height);
        nbt.func_74768_a("len", this.length);
        nbt.func_74768_a("freq", this.frequency);
        if (this.shape != null) {
            nbt.func_74768_a("shape", this.shape.ordinal());
        }
        if (this.pos != null) {
            nbt.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        }
        if (this.box != null) {
            nbt.func_218657_a("box", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)this.box.func_76341_a())));
            nbt.func_218657_a("box2", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)this.box.func_76340_b())));
        }
        if (this.structureName != null) {
            nbt.func_74778_a("struct_name", this.structureName);
        }
        if (this.staticSchematicName != null) {
            nbt.func_74778_a("static_name", this.staticSchematicName);
        }
        if (this.stack != null) {
            nbt.func_218657_a("stack", (INBT)((ItemStack)this.stack.func_76341_a()).serializeNBT());
            nbt.func_218657_a("stack2", (INBT)((ItemStack)this.stack.func_76340_b()).serializeNBT());
        }
        if (!this.equation.isEmpty()) {
            nbt.func_74778_a("equa", this.equation);
        }
        this.anchorPos.ifPresent(anch_pos -> nbt.func_218657_a("anch_pos", (INBT)NBTUtil.func_186859_a((BlockPos)anch_pos)));
        return nbt;
    }

    public void setEquation(String localEquation) {
        this.equation = localEquation;
    }

    public String getEquation() {
        return this.equation;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Optional<BlockPos> getAnchorPos() {
        return this.anchorPos;
    }

    public void setAnchorPos(Optional<BlockPos> anchorPos) {
        this.anchorPos = anchorPos;
    }

    public boolean hasReceivedInfo() {
        return this.receivedInfo;
    }

    public void setReceivedInfo() {
        this.receivedInfo = true;
    }
}

